/*
* Copyright (c) 1994-1998 Sun Microsystems, Inc. All Rights Reserved.
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for NON-COMMERCIAL or COMMERCIAL purposes and without fee is
* hereby granted. Please refer to the file
* http://java.sun.com/nav/business/trademark_guidelines.html for further
* important copyright and trademark information and to
* http://java.sun.com/nav/business/index.html for further important licensing
* information for the Java (tm) Technology.
* 
* SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
* SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
* IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR
* NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
* LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR
* ITS DERIVATIVES.
* 
* THIS SOFTWARE IS NOT DESIGNED OR INTENDED FOR USE OR RESALE AS ON-LINE
* CONTROL EQUIPMENT IN HAZARDOUS ENVIRONMENTS REQUIRING FAIL-SAFE PERFORMANCE,
* SUCH AS IN THE OPERATION OF NUCLEAR FACILITIES, AIRCRAFT NAVIGATION OR
* COMMUNICATION SYSTEMS, AIR TRAFFIC CONTROL, DIRECT LIFE SUPPORT MACHINES, OR
* WEAPONS SYSTEMS, IN WHICH THE FAILURE OF THE SOFTWARE COULD LEAD DIRECTLY TO
* DEATH, PERSONAL INJURY, OR SEVERE PHYSICAL OR ENVIRONMENTAL DAMAGE ("HIGH
* RISK ACTIVITIES"). SUN SPECIFICALLY DISCLAIMS ANY EXPRESS OR IMPLIED
* WARRANTY OF FITNESS FOR HIGH RISK ACTIVITIES.
*/

import java.applet.*;
import java.awt.*;
import java.awt.image.*;
import java.net.*;
import java.util.*;

public class ImageList extends Object
{
   private Applet applet;

   private ImageItem[] list;
   private int current = 0;

   private URL docBase;

   private int number = 0;
   private long length = 0;
   private long time = 0;

   private boolean mouseEnter = false;

   public ImageList(Applet applet)
   {
      this.applet = applet;

      docBase = applet.getDocumentBase();
   }

   public void loadImages()
   {
      // Parse the number of frames.

      String value = applet.getParameter("number");

      if (value != null)
      {
         number = Integer.parseInt(value);
      }

      else
      {
         number = 0;
      }

      // Parse the length.

      value = applet.getParameter("length");

      if (value != null)
      {
         length = Integer.parseInt(value);
      }

      else
      {
         length = 3;
      }

      length = length * 1000;
      list = new ImageItem[number];

      for (int i = 0; i < number; i++)
      {
         try
         {
            String item = applet.getParameter("item" + i);
            String[] field = parseStrings(item, "|");

            Image img = applet.getImage(docBase, field[0]);

            applet.showStatus("Loading: " + field[0]);

            URL url = new URL(field[1]);
            list[i] = new ImageItem(img, field[1], url);
         }

         catch(MalformedURLException e)
         {
            e.printStackTrace();
         }
      }
   }

   public String getURLString()
   {
      return list[current].str;
   }

   public URL getURL()
   {
      return list[current].url;
   }

   public void setMouseEnter(boolean value)
   {
      mouseEnter = value;
   }

   public void update()
   {
      if (time > 0)
      {
         if ((System.currentTimeMillis() - time) >= length)
         {
            nextImage();
            time = System.currentTimeMillis();

            if (mouseEnter)
            {
               applet.showStatus(list[current].str);
            }
         }
      }

      else
      {
         time = System.currentTimeMillis();
      }
   }

   private void nextImage()
   {
      if ((current + 1) >= number)
      {
         current = 0;
      }

      else
      {
         current++; 
      }
   }

   public void paint(Graphics g)
   {
      g.drawImage(list[current].img, 0, 0, applet);
   }

   public String[] parseStrings(String str, String sep)
   {
      if (str != null)
      {
         StringTokenizer st = new StringTokenizer(str, sep);
         String result[] = new
         String[st.countTokens()];

         for (int i = 0; i < result.length; i++)
         {
            result[i] = st.nextToken();
         }

         return result;
      }

      else
      {
         return null;
      }
   }
}
